
/////////////////////////////////////////////////////////
// general parameters

//transforms

float4x4	shader_transform_world;
float4x4	shader_transform_view;
float4x4	shader_transform_proj;
float4x4	shader_transform_worldView;
float4x4	shader_transform_viewProj;
float4x4	shader_transform_worldViewProj;

//lights

float4		shader_light_position;
float4		shader_light_direction;
float4		shader_light_diffuse;
float4		shader_light_ambient;
float4		shader_light_specular;

//camera

float4 		shader_camera_eyePosition;
float4 		shader_camera_eyeVector;
float4 		shader_camera_upVector;

//material

float4		shader_material_diffuse;
float4		shader_material_ambient;
float4		shader_material_specular;
float		shader_material_eccentricity;
float		shader_material_transparency;
float		shader_material_reflectivity;

//textures

TEXTURE		shader_texture_0;
TEXTURE		shader_texture_1;
TEXTURE		shader_texture_2;
TEXTURE		shader_texture_3;
TEXTURE		shader_texture_4;
TEXTURE		shader_texture_5;
TEXTURE		shader_texture_cubemap;
TEXTURE		shader_texture_shadowmap;

//geometry

float4		shader_geometry_colour;

/////////////////////////////////////////////////////////
// unique parameters

float4x4	g_maskPanoMat;
float3		g_maskPanoShift;

////////////////////////////////////////////////////////////////////
// structures

struct VS_INPUT
{
	float4 position		: POSITION;
};

struct VS_OUTPUT_HIGH
{
	float4 position		: POSITION;
	float3 texCoords	: TEXCOORD0;
};

////////////////////////////////////////////////////////////////////
// functions

VS_OUTPUT_HIGH vs_mask_area( VS_INPUT input )
{
	VS_OUTPUT_HIGH output = (VS_OUTPUT_HIGH) 0;

	output.texCoords = mul(input.position,g_maskPanoMat);
	output.position = mul(input.position, shader_transform_viewProj);
	
	return output;
}

///////////////////////////////////////////////////////////////////////

sampler sampler_colour_cube = sampler_state 
{ 
	Texture = (shader_texture_cubemap); 
};

///////////////////////////////////////////////////////////////////////

float4 ps_mask_area( VS_OUTPUT_HIGH input ) : COLOR0
{
	float3 nCubeTexCoords = normalize(input.texCoords);
	nCubeTexCoords -= g_maskPanoShift*2;
	
	return float4(1,1,1,texCUBE(sampler_colour_cube, nCubeTexCoords).a < 0.9 ? 0.0 : 1.0);
}

////////////////////////////////////////////////////////////

technique tech_mask_area_11_20
{
	pass P0
	{
		VertexShader = compile vs_1_1 vs_mask_area();	
		PixelShader = compile ps_2_0 ps_mask_area();	
	}
}

technique tech_mask_area_11_00
{
	pass P0
	{
		VertexShader = compile vs_1_1 vs_mask_area();	
	}
}